/*
 * Basic example for hydra tutorial use.
 * 
 * This is a very simplistic OpenMP program
 * that just does a bubble sort forever
 *
 * 2015-12-14
 */
#include <algorithm>
#include <omp.h>
#include <iostream>

using namespace std;

/*
 * This does the actual bubble sort 
 * on an array defined by the begin and
 * end points specified
 */
template <typename T> 
void bubble_sort(T * begin, T * end) {
  bool swapped = true;
  while (begin != end-- && swapped) {
    swapped = false;
    for (T * i = begin; i != end; ++i) 
      if (*(i + 1) < *i) {
	swap(*i, *(i+1));
        swapped = true;
      }
  }
}

/*
 * Main function 
 */ 
int main() {
  /* Below: some random data */
  int a[] = {100, 2, 56, 200, -52, 3, 99, 33, 177, -199};
  /* Below: an easy reference to the size of the data */
  int n   = 10;
  /*
   * Below: use this to capture the number of threads being
   * used just so we can print something of interest and
   * also check it's run or running
   */ 
  int t;

  /*
   * Run this section in parallel so as to capture the thread
   * count
   */
#pragma omp parallel
  {
  t = omp_get_num_threads();
  }

  /*
   * Run this on the master thread only to get the print out
   * just the once.
   */
#pragma omp master
  {
  cout <<"number of threads used = " << t << endl;
  }

  /* 
   * Next we run a bubble sort on a private copy of a 
   * and run it forever. We don't care about the results
   * as this is just busy work
  */
#pragma parallel private(a)
  {
  while (true) // run forever...
    bubble_sort(a, a+n);
  }

  return 0;
}
